''
''
''FB Particle Engine - Tutorial 1 Source Code
''
''

#Define FBPE_FLAGS_EMITTING      1
#Define FBPE_FLAGS_VISIBLE       2
#Define FBPE_FLAGS_MOVING        4

#Define FBPE_LIFE_IMMORTAL       0
#Define FBPE_LIFE_DEATH          1
#Define FBPE_LIFE_REINCARNATION  2

Type FBPE_Particle
  As Single x, y, z
  As Single vx, vy, vz
  
  As Integer life

  'r = radius.  Used mainly to keep track of whether the particle has been initialized
  'yet, or in collision detection.
  As Integer r
End Type

  Type FBPE_Particle_Emitter

    As Integer location_x, location_y, location_z

    As Integer maxparticles, numparticles, emissionrate
    
    As Integer initial_life=100
    As Byte life_behaviour=0
    As Integer deadparticles

    As Byte emitterflags

    As FBPE_Particle Ptr particles

  End Type

Sub FBPE_Init_Emitter (emitter As FBPE_Particle_Emitter, mparticles As Integer, prate As Integer)
Dim As Integer i

  emitter.maxparticles = mparticles
  emitter.emissionrate = prate
  emitter.particles = Allocate(mparticles*SizeOf(FBPE_Particle))
  'Set each particle to be uninitialized
  For i = 0 To mparticles-1
    emitter.particles[i].r = 0
  Next i
End Sub

Sub FBPE_Start_Emitter (emitter As FBPE_Particle_Emitter)
  emitter.emitterflags = (FBPE_FLAGS_EMITTING Or FBPE_FLAGS_VISIBLE Or FBPE_FLAGS_MOVING)
End Sub

Sub FBPE_Pause_Emitter (emitter As FBPE_Particle_Emitter)
  'Turn off all flags except visibility
  emitter.emitterflags = emitter.emitterflags And FBPE_FLAGS_VISIBLE
End Sub

Sub FBPE_ToggleVisibility_Emitter (emitter As FBPE_Particle_Emitter)
  'Toggle visible flag
  emitter.emitterflags = emitter.emitterflags Xor FBPE_FLAGS_VISIBLE
End Sub

Sub FBPE_Update_Emitter (emitter As FBPE_Particle_Emitter)
Dim As Integer i

  'If all particles are dead, then skip everything else
  If emitter.deadparticles = emitter.maxparticles Then Exit Sub

  'If we're still emitting...
  If (emitter.emitterflags Or FBPE_FLAGS_EMITTING) <> 0 Then
    'Emit the number of particles we're supposed to emit...
    emitter.numparticles += emitter.emissionrate

    'If we've emitted as many as we can, turn the emitter off.
    If emitter.numparticles > emitter.maxparticles Then
      emitter.numparticles = emitter.maxparticles
      emitter.emitterflags = emitter.emitterflags And (Not FBPE_FLAGS_EMITTING)
    End If
  End If

  If emitter.life_behaviour <> 0 Then
    For i = 0 To emitter.numparticles-1
      emitter.particles[i].life -= 1
      If emitter.particles[i].life = 0 Then
        If emitter.life_behaviour = FBPE_LIFE_REINCARNATION Then
          'Set particle to be re-initialized
          emitter.particles[i].r = 0
          emitter.particles[i].life = emitter.initial_life
        ElseIf emitter.life_behaviour = FBPE_LIFE_DEATH Then
          emitter.deadparticles += 1
          If emitter.deadparticles = emitter.maxparticles Then Exit Sub
        End If
      End If
    Next i
  End If

  If (emitter.emitterflags Or FBPE_FLAGS_MOVING) <> 0 Then
    For i = 0 To emitter.numparticles-1
      'If the particle has not yet been initialized...
      If emitter.particles[i].r = 0 Then
        emitter.particles[i].x = emitter.location_x
        emitter.particles[i].y = emitter.location_y
        emitter.particles[i].z = emitter.location_z
        emitter.particles[i].vx = 1
        emitter.particles[i].vy = 1
        emitter.particles[i].vz = 1
        emitter.particles[i].r = 1
        emitter.particles[i].life = emitter.initial_life
      Else
        'Move the particles, with a small amount of randomness built in
        emitter.particles[i].x += emitter.particles[i].vx + (Rnd*2) - 1
        emitter.particles[i].y += emitter.particles[i].vy + (Rnd*2) - 1
        emitter.particles[i].z += emitter.particles[i].vz + (Rnd*2) - 1
      End If
    Next i
  End If
End Sub

Sub FBPE_Draw_Emitter (emitter As FBPE_Particle_Emitter)
Dim As Integer i

  If (emitter.emitterflags Or FBPE_FLAGS_VISIBLE) = 0 Then Exit Sub
  For i = 0 To emitter.numparticles-i
   
   'Default - dots
   If emitter.particles[i].life <> 0 Or emitter.life_behaviour = FBPE_LIFE_IMMORTAL Then PSet(emitter.particles[i].x, emitter.particles[i].y), &hffffff
   
   'Circles
   'If emitter.particles[i].life <> 0 Or emitter.life_behaviour = FBPE_LIFE_IMMORTAL Then Circle(emitter.particles[i].x, emitter.particles[i].y), 5, &hffffff
   
   'Lines - this actually looks kinda cool, like rain or sparks
   'If emitter.particles[i].life <> 0 Or emitter.life_behaviour = FBPE_LIFE_IMMORTAL Then Line(emitter.particles[i].x-2, emitter.particles[i].y-2)-(emitter.particles[i].x+1, emitter.particles[i].y+1), &hffffff
   
   'Squares
   'If emitter.particles[i].life <> 0 Or emitter.life_behaviour = FBPE_LIFE_IMMORTAL Then Line(emitter.particles[i].x-2, emitter.particles[i].y-2)-(emitter.particles[i].x+2, emitter.particles[i].y+2), &hffffff, B
   
   'Filled boxes - kinda shimmery looking
   'If emitter.particles[i].life <> 0 Or emitter.life_behaviour = FBPE_LIFE_IMMORTAL Then Line(emitter.particles[i].x-1, emitter.particles[i].y-1)-(emitter.particles[i].x+1, emitter.particles[i].y+1), &hffffff, BF
  Next i
End Sub

''End FB Particle Engine Tutorial 1