'$DYNAMIC

DECLARE SUB LoadFont ()
DECLARE SUB PUTTEXT (Text$, C, XPos, YPos, Adj)
DECLARE SUB Introduction ()
DECLARE SUB DRAWCHAR (WhichOne$, Position%, XPos%, YPos%)
DECLARE SUB rgb (palval%, redval%, grnval%, bluval%)
DECLARE SUB pausit (ticker)
DECLARE SUB CutSceneText (Anchor$)
DIM SHARED CharSpr(224) AS INTEGER
DIM SHARED CharMsk(224) AS INTEGER

DIM SHARED CharSet(32 TO 126, 1 TO 8, 1 TO 6) AS INTEGER

RANDOMIZE TIMER

UPVAR$ = CHR$(0) + "H": DOWNVAR$ = CHR$(0) + "P"
LEFTVAR$ = CHR$(0) + "K": RIGHTVAR$ = CHR$(0) + "M"

ItemPoint(0) = 201

LoadFont

SCREEN 0
WIDTH 80
DEFINT X-Y
CLS
COLOR 15
MainMenu:
LOCATE 1, 1
FOR y = 1 TO 22
	PRINT ""
NEXT y
COLOR 0, 15
PRINT " The ARC Legacy v1.5 final                                         by Mark Hall "
COLOR 15, 0
 LOCATE 2, 5: PRINT "ͻ"
 LOCATE 3, 5: PRINT "   Main Menu  "
 LOCATE 4, 5: PRINT "͹"
 LOCATE 5, 5: PRINT " 1. New Game  "
 LOCATE 6, 5: PRINT " 2. Load Game "
 LOCATE 7, 5: PRINT " 3. Help      "
 LOCATE 8, 5: PRINT " 4. Quit      "
 LOCATE 9, 5: PRINT "͹"
LOCATE 10, 5: PRINT "              "
LOCATE 11, 5: PRINT "ͼ"
 LOCATE 12, 6: PRINT ""
LOCATE 10, 7: INPUT "]", Choice
IF Choice = 1 THEN GOTO NewGame
IF Choice = 2 THEN GOTO LoadGame
IF Choice = 3 THEN GOSUB HelpMePlease
IF Choice = 4 THEN GOSUB ExitYN

GOTO MainMenu

NewGame:
SCREEN 13
Introduction
OPEN "CHAIN.DAT" FOR OUTPUT AS #1
	PRINT #1, "New Game"
CLOSE #1
RUN "ENGINE"

LoadGame:
	direction% = 2
	LOCATE 10, 23: PRINT "ͻ"
	LOCATE 11, 23: PRINT " Enter filename:                "
	LOCATE 12, 23: PRINT "                                "
	LOCATE 13, 23: PRINT "ͼ"
	 LOCATE 14, 24: PRINT ""
	LOCATE 12, 25: INPUT "]", SaveFile$
	OPEN "CHAIN.DAT" FOR OUTPUT AS #1
		PRINT #1, "Load Game"
		PRINT #1, SaveFile$
	CLOSE #1
RUN "ENGINE"

HelpMePlease:
	LOCATE 1, 1
	PRINT "ͻ"
	PRINT " The ARC Legacy Help     Page 1 "
	PRINT "͹"
	PRINT " Controls                       "
	PRINT "                        "
	PRINT " ESC: Bring up/get rid of menu  "
	PRINT " ARROWS: Move around map/menu   "
	PRINT " SPACE/ENTER: Action key        "
	PRINT " A: Arrange Items               "
	PRINT " #1-4: Change visible character "
	PRINT " Talk to people by walking into "
	PRINT " them.                          "
	PRINT "ͼ"
	PRINT ""
	WHILE INKEY$ = "": WEND
	LOCATE 1, 1
	PRINT "ͻ"
	PRINT " The ARC Legacy help     Page 2 "
	PRINT "͹"
	PRINT " Battles                        "
	PRINT "                         "
	PRINT " Battles are turn-based.  You   "
	PRINT " must first select the actions  "
	PRINT " of all four characters, and    "
	PRINT " after that, the battle plays   "
	PRINT " itself for one round.  The     "
	PRINT " enemies and characters do      "
	PRINT " their actions in a random      "
	PRINT " order.  Then the next round    "
	PRINT " starts and the cycle repeats   "
	PRINT " until either you or the        "
	PRINT " enemy is dead.  The            "
	PRINT " experience points received     "
	PRINT " are divided between the        "
	PRINT " surviving characters.          "
	PRINT "ͼ"
	PRINT ""
	WHILE INKEY$ = "": WEND
	LOCATE 1, 1
	PRINT "ͻ"
	PRINT " The ARC Legacy help     Page 3 "
	PRINT "͹"
	PRINT " Weapons                        "
	PRINT "                         "
	PRINT " Weapons are used differently   "
	PRINT " by all the characters, as      ͻ"
	PRINT " shown in the chart to the       Individual characters' specialties "
	PRINT " right.  Everyone can equip any ͹"
	PRINT " weapon, but some are most       CHARACTER        WEAPON           "
	PRINT " powerful when equipped to the   Rydar:           Swords           "
	PRINT " right character.                Kalrin:          Staffs           "
	PRINT "                                 Bokk:            Axes             "
	PRINT " To equip, go to the 'Items'     Malcolm:         None             "
	PRINT " submenu and select the weapon  ͼ"
	PRINT " and who you want to equip it   "
	PRINT " to.  If the character is       "
	PRINT " already holding a weapon, then "
	PRINT " the two weapons switch places. "
	PRINT "ͼ"
	PRINT ""
	WHILE INKEY$ = "": WEND
RETURN

ExitYN:
	LOCATE 10, 23: PRINT "ͻ"
	LOCATE 11, 23: PRINT " Do you really want to exit? (Y/N) "
	LOCATE 12, 23: PRINT "ͼ"
	 LOCATE 13, 24: PRINT ""
	i$ = ""
	WHILE i$ = ""
		i$ = INKEY$
		IF UCASE$(i$) = "Y" THEN SYSTEM
	WEND
RETURN

SelectAttackEnemy:
	act2$ = ""
	WHILE act2$ <> " " AND act2$ <> CHR$(13)
		Aero% = (EnemSel - 1) * 60
		LINE (Aero% + 30, 106)-(Aero% + 30, 116), 15
		LINE (Aero% + 25, 110)-(Aero% + 30, 106), 15
		LINE (Aero% + 30, 106)-(Aero% + 35, 110), 15
		act2$ = INKEY$
		IF act2$ = LEFTVAR$ THEN
			EnemSel = EnemSel - 1
			IF EnemSel < 1 THEN EnemSel = EnemGroupAttack
			LINE (Aero% + 25, 106)-(Aero% + 35, 116), 0, BF
		END IF
		IF act2$ = RIGHTVAR$ THEN
			EnemSel = EnemSel + 1
			IF EnemSel > EnemGroupAttack THEN EnemSel = 1
			LINE (Aero% + 25, 106)-(Aero% + 35, 116), 0, BF
		END IF
	WEND
	LINE (Aero% + 30, 106)-(Aero% + 30, 116), 0
	LINE (Aero% + 25, 110)-(Aero% + 30, 106), 0
	LINE (Aero% + 30, 106)-(Aero% + 35, 110), 0
	Action$(TeamDude) = "KILL:" + STR$(EnemSel)
RETURN

REM $STATIC
DEFSNG X-Y
SUB CutSceneText (Anchor$)
	FOR x% = 1 TO 4
		PRINT SPACE$(40)
	NEXT x%
	LOCATE 1, 1
	Reading% = 0
	OPEN "dat\Cutscene.dat" FOR INPUT AS #1
		WHILE NOT EOF(1)
			LINE INPUT #1, TempStr$
			IF LEN(TempStr$) <> 4 AND Reading% = 1 THEN
				FOR y = 1 TO LEN(TempStr$)
					MID$(TempStr$, y, 1) = CHR$(ASC(MID$(TempStr$, y, 1)) - 1)
				NEXT y
			END IF
			IF Reading% = 1 AND TempStr$ <> "-" AND TempStr$ <> "-----" THEN PRINT TempStr$
			IF Reading% = 1 AND TempStr$ = "-" THEN
				WHILE INKEY$ = "": WEND
				LOCATE 1, 1
				FOR x% = 1 TO 4
					PRINT SPACE$(40)
				NEXT x%
				LOCATE 1, 1
			END IF
			IF TempStr$ = Anchor$ THEN Reading% = 1
			IF TempStr$ = "-----" THEN Reading% = 0
		WEND
	CLOSE #1
END SUB

SUB DRAWCHAR (WhichOne$, Position%, XPos%, YPos%)
	SELECT CASE Position%
	CASE 1
		OPEN "img\" + WhichOne$ FOR INPUT AS #1
			FOR loading% = 1 TO 75
				LINE INPUT #1, TempStr$
				FOR loading2% = 1 TO 60
					colorval% = ASC(MID$(TempStr$, loading2%, 1)) - 33
					IF colorval% > 0 THEN PSET (XPos% + loading2%, YPos% + loading%), colorval%
				NEXT loading2%
			NEXT loading%
		CLOSE #1
	CASE 3
		OPEN "img\" + WhichOne$ FOR INPUT AS #1
			FOR loading% = 1 TO 75
				LINE INPUT #1, TempStr$
				FOR loading2% = 1 TO 60
					colorval% = ASC(MID$(TempStr$, (61 - loading2%), 1)) - 33
					IF colorval% > 0 THEN PSET (XPos% + loading2%, YPos% + loading%), colorval%
				NEXT loading2%
			NEXT loading%
		CLOSE #1
	CASE 2
		DEF SEG = VARSEG(CharSpr(0))
		BLOAD "sprmsk\" + WhichOne$ + ".spr", VARPTR(CharSpr(0))
		DEF SEG = VARSEG(CharMsk(0))
		BLOAD "sprmsk\" + WhichOne$ + ".msk", VARPTR(CharMsk(0))
		PUT (XPos%, YPos% - 15), CharMsk, AND
		PUT (XPos%, YPos% - 15), CharSpr, OR
	CASE 8
		DEF SEG = VARSEG(CharSpr(0))
		BLOAD "sprmsk\" + WhichOne$ + "B.spr", VARPTR(CharSpr(0))
		DEF SEG = VARSEG(CharMsk(0))
		BLOAD "sprmsk\" + WhichOne$ + "B.msk", VARPTR(CharMsk(0))
		PUT (XPos%, YPos% - 15), CharMsk, AND
		PUT (XPos%, YPos% - 15), CharSpr, OR
	CASE 4
		DEF SEG = VARSEG(CharSpr(0))
		BLOAD "sprmsk\" + WhichOne$ + "L.spr", VARPTR(CharSpr(0))
		DEF SEG = VARSEG(CharMsk(0))
		BLOAD "sprmsk\" + WhichOne$ + "L.msk", VARPTR(CharMsk(0))
		PUT (XPos%, YPos% - 15), CharMsk, AND
		PUT (XPos%, YPos% - 15), CharSpr, OR
	CASE 6
		DEF SEG = VARSEG(CharSpr(0))
		BLOAD "sprmsk\" + WhichOne$ + "R.spr", VARPTR(CharSpr(0))
		DEF SEG = VARSEG(CharMsk(0))
		BLOAD "sprmsk\" + WhichOne$ + "R.msk", VARPTR(CharMsk(0))
		PUT (XPos%, YPos% - 15), CharMsk, AND
		PUT (XPos%, YPos% - 15), CharSpr, OR
	END SELECT
END SUB

DEFINT X-Y
SUB Introduction
	CLS
	rgb 123, 0, 0, 16
	LINE (0, 150)-(320, 150), 123
	PAINT (1, 1), 123
	FOR x = 1 TO 50
		PSET (RND * 320, RND * 100), 14
	NEXT x
	CIRCLE (270, 30), 10, 15
	PAINT (270, 30), 15
	CIRCLE (275, 25), 10, 123
	PAINT (275, 25), 123
	LINE (40, 30)-(60, 150), 0, BF
	CIRCLE (50, 20), 16, 0
	PAINT (50, 20), 0
	LINE (100, 60)-(150, 150), 0, BF
	LINE (150, 75)-(200, 150), 0, BF
	LINE (200, 50)-(250, 150), 0, BF
	LINE (260, 55)-(310, 150), 0, BF
	LOCATE 22, 10
	PRINT "In the year 2085, the Earth was"
	LOCATE 23, 10
	PRINT "ravaged by nuclear warfare."
	WHILE INKEY$ = "": WEND
	rgb 123, 63, 63, 63
	SLEEP 1
	rgb 123, 63, 0, 0
	FOR x = 1 TO 200
		CIRCLE (160, 140 - (x / 3)), x, 14
	NEXT x
	SLEEP 1
	rgb 0, 63, 63, 0
	LINE (0, 0)-(320, 200), 0, BF
	COLOR 14
	LOCATE 1, 1
	PRINT "Clouds of dust blocked sunlight,"
	PRINT "    killing all the plants"
	FOR x% = 63 TO 1 STEP -2
		rgb 0, x%, x%, x% / 4
		pausit 1
	NEXT x%
	rgb 0, 0, 0, 0
	rgb 123, 0, 0, 0
	COLOR 123
	LOCATE 5, 5
	PRINT "Electromagnetic pulse knocked out"
	LOCATE 6, 8
	PRINT "everything electric."
	WHILE INKEY$ = "": WEND
	FOR x% = 1 TO 63 STEP 2
		rgb 123, x%, x%, x%
		pausit 1
	NEXT x%
	WHILE INKEY$ = "": WEND
	rgb 124, 0, 0, 0
	COLOR 124
	LOCATE 8, 6
	PRINT "The few human survivors were"
	LOCATE 9, 5
	PRINT "forced to live underground for"
	LOCATE 10, 10
	PRINT "centuries"
	FOR x% = 1 TO 63 STEP 2
		rgb 124, x%, x% / 4, x%
		pausit 1
	NEXT x%
	WHILE INKEY$ = "": WEND
	rgb 125, 0, 0, 0
	COLOR 125
	LOCATE 15, 3
	PRINT "The first rays of sunlight came"
	LOCATE 16, 4
	PRINT "through at last, revealing a"
	LOCATE 17, 9
	PRINT "barren wasteland"
	FOR x% = 1 TO 63 STEP 2
		rgb 14, 63 - x%, 63 - x%, 16 - (x% / 4)
		rgb 123, 63 - x%, 63 - x%, 63 - x%
		rgb 124, 63 - x%, 16 - (x% / 4), 63 - x%
		rgb 125, x%, x%, x% / 4
		FOR y% = 1 TO 2
			LINE (RND * 200, RND * 80 + 20)-(300, 10), 125
		NEXT y%
		pausit 1
	NEXT x%
	WHILE INKEY$ = "": WEND
	COLOR 15
	LOCATE 20, 1
	PRINT "The handful of humans had to"
	PRINT "work hard to reclaim the"
	PRINT "       lost Earth"
	WHILE INKEY$ = "": WEND
	FOR x = 0 TO 10
		FOR y = 0 TO 32
			LINE (10 * y + x, 0)-(10 * y + x, 200), 0
		NEXT y
		pausit 1
	NEXT x
	FOR x = 1 TO 255
		rgb x, 0, 0, 0
	NEXT x
	BLOAD "img/intropic.bsv"
	LINE (180, 40)-(200, 80), 24, BF
	LINE (230, 40)-(280, 80), 24, BF
	LINE (310, 40)-(320, 80), 24, BF
	LINE (180, 81)-(320, 200), 25, BF
	LINE (130, 120)-(179, 200), 24, BF
	CIRCLE (230, 110), 15, 0
	PAINT (230, 110), 0
	LINE (215, 110)-(245, 150), 0, BF
	CIRCLE (290, 110), 15, 0
	PAINT (290, 110), 0
	LINE (275, 110)-(305, 150), 0, BF
	FOR x = 1 TO 63 STEP 2
		FOR y = 1 TO 15
			rgb y + 15, x * (y / 32), x * (y / 16), x * (y / 32)
		NEXT y
		rgb 15, x * .5, x, x * .5
		rgb 7, x * .35, x * .7, x * .35
		rgb 8, x * .25, x * .5, x * .25
		pausit 1
	NEXT x
	rgb 4, 64, 0, 0
	LOCATE 1, 1
	PUTTEXT "No technology", 4, 1, 0, 0
	PUTTEXT "No buildings left standing", 4, 1, 10, 0
	PUTTEXT "No scientific knowledge", 4, 1, 20, 0
	PUTTEXT "Mankind was sent back to the middle ages", 4, 1, 30, 0
	WHILE INKEY$ = "": WEND
	FOR x = 63 TO 1 STEP -2
		FOR y = 1 TO 15
			rgb y + 15, x * (y / 32), x * (y / 16), x * (y / 32)
		NEXT y
		rgb 15, x * .5, x, x * .5
		rgb 7, x * .35, x * .7, x * .35
		rgb 8, x * .25, x * .5, x * .25
		pausit 1
	NEXT x
	CLS
	PALETTE
	DRAWCHAR "Rydar.img", 1, 10, 40
	DRAWCHAR "Kalrin.img", 1, 80, 40
	DRAWCHAR "Bokk.img", 1, 150, 40
	DRAWCHAR "Malcolm.img", 1, 220, 40
	PRINT "There was a group of people known as"
	PRINT "the Archaeologists, who were"
	PRINT "dedicated to finding the remains of"
	PRINT "the previous civilization"
	LOCATE 18, 1
	PRINT "   Rydar   Kalrin   Bokk   Malcolm"
	PRINT
	PRINT "Their task was to help restore the"
	PRINT "world to the way it was centuries"
	PRINT "before..."
	WHILE INKEY$ = "": WEND
	CLS
	BLOAD "img\title.bsv"
	WHILE INKEY$ = "": WEND
	PALETTE
	CLS
	LOCATE 10, 1: PRINT "Outside the Kingdom of Pruthe..."
	WHILE INKEY$ = "": WEND
	CLS
	LINE (0, 35)-(320, 100), 1, BF
	LINE (0, 101)-(320, 200), 2, BF
	DRAWCHAR "Rydart.img", 1, 170, 55
	DRAWCHAR "Malcolmt.img", 1, 120, 57
	DRAWCHAR "Kalrint.img", 1, 142, 63
	DRAWCHAR "Bokkt.img", 3, 5, 63
	COLOR 15
	CutSceneText "INT1"
END SUB

DEFINT A-W, Z
SUB LoadFont

DIM Counter, Char$

Char$ = " "
Counter = 0

OPEN "dat\font8x6.dat" FOR BINARY AS #1

FOR i = 32 TO 126
 FOR j = 1 TO 6
  Counter = Counter + 1
  GET #1, Counter, Char$
  Number = ASC(Char$)
  FOR k = 7 TO 0 STEP -1
   IF 2 ^ k > Number THEN CharSet(i, 8 - k, 7 - j) = 0 ELSE Number = Number - 2 ^ k: CharSet(i, 8 - k, 7 - j) = 1
  NEXT k
 NEXT j
NEXT i

CLOSE #1

END SUB

DEFSNG A-W, Z
SUB pausit (ticker)
	ticker = ticker / 100
	ticker2 = TIMER
	WHILE (TIMER - ticker2) < ticker
	WEND
END SUB

DEFSNG X-Y
SUB PUTTEXT (Text$, C, XPos, YPos, Adj)
	IF XPos = -1 THEN XPos = 160 - LEN(Text$) * 3
	FOR i = 1 TO LEN(Text$)
		Char = ASC(MID$(Text$, i, 1))
			FOR j = 1 TO 8
				FOR k = 1 TO 6
					IF CharSet(Char, j, k) = 1 THEN
					PSET (XPos + k + (i * 6) - 6, YPos + j), C + (Adj * j)
					PSET (XPos + k + (i * 6) - 6, YPos + j + 1), 0
				END IF
			NEXT k
		NEXT j
	NEXT i
END SUB

DEFINT X-Y
SUB rgb (palval%, redval%, grnval%, bluval%)
  IF redval% < 0 THEN redval% = 0
  IF redval% > 63 THEN redval% = 63
  IF grnval% < 0 THEN grnval% = 0
  IF grnval% > 63 THEN grnval% = 63
  IF bluval% < 0 THEN bluval% = 0
  IF bluval% > 63 THEN bluval% = 63
  OUT &H3C8, palval%
  OUT &H3C9, redval%
  OUT &H3C9, grnval%
  OUT &H3C9, bluval%
END SUB

